#include <jvmpi.h>

// global jvmpi interface pointer
static JVMPI_Interface *jvmpi_interface;

// function for handling event notification
void notifyEvent(JVMPI_Event *event) {
  switch(event->event_type) {
  case JVMPI_EVENT_CLASS_LOAD: 
    fprintf(stderr, "myprofiler> Class Load : %s\n", event->u.class_load.class_name);
    break;
  }                       
}

// profiler agent entry point
extern "C" { 
  JNIEXPORT jint JNICALL JVM_OnLoad(JavaVM *jvm, char *options, void *reserved) {
    fprintf(stderr, "myprofiler> initializing ..... \n");
    
    // get jvmpi interface pointer
    if ((jvm->GetEnv((void **)&jvmpi_interface, JVMPI_VERSION_1)) < 0) {
      fprintf(stderr, "myprofiler> error in obtaining jvmpi interface pointer\n");
      return JNI_ERR;
    } 
    
    // initialize jvmpi interface
    jvmpi_interface->NotifyEvent = notifyEvent;
    
    // enabling class load event notification
    jvmpi_interface->EnableEvent(JVMPI_EVENT_CLASS_LOAD, NULL);

    fprintf(stderr, "myprofiler> .... ok \n\n");
    return JNI_OK;
  }
}


